//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function q2=%s_d_CLquat(a,q1);

// LAST UPDATE
// 03/05/2007
//
// Authors
// CNES - DCT/SB
//

// Declarations:


// Code:

[li co]=size(a);
if li>co a=a'; end,
if min([li co])~=1 CL__error("check dimensions"); end,
if max([li co])~=size(q1) CL__error("check dimensions"); end,
nrm=q1.r.^2 + q1.i(1,:).^2 + q1.i(2,:).^2 + q1.i(3,:).^2;
q2=CL_rot_defQuat(q1.r.*a./nrm,-q1.i(1,:).*a./nrm,-q1.i(2,:).*a./nrm,-q1.i(3,:).*a./nrm);

endfunction
